// listInsertionSort.java
// demonstruje sortowanie przy uyciu listy uporzdkowanej
// uruchomienie programu: C>java ListInsertionSortApp
////////////////////////////////////////////////////////////////
class Link
   {
   public long dData;                  // dane
   public Link next;                   // nastpny element
// -------------------------------------------------------------
   public Link(long dd)                // konstruktor
      { dData = dd; }
// -------------------------------------------------------------
   }  // koniec klasy Link
////////////////////////////////////////////////////////////////
class SortedList
   {
   private Link first;            // referencja do pierwszego elementu listy
// -------------------------------------------------------------
   public SortedList()            // konstruktor bezargumentowy
      { first = null; }                    // pusta lista
// -------------------------------------------------------------
   public SortedList(Link[] linkArr)  // konstruktor wstawiajcy do listy
      {                               // elementy tablicy
      first = null;                        // inicjalizacja listy
      for(int j=0; j<linkArr.length; j++)  // wstawianie elementw tablicy...
         insert( linkArr[j] );             // ...do listy
      }
// -------------------------------------------------------------
   public void insert(Link k)     // wstawianie z zachowaniem porzdku
      {
      Link previous = null; 
      Link current = first;            // rozpoczynamy od pocztku listy
                                       // dopki nie koniec listy...
      while(current != null && k.dData > current.dData)
         {                             // ...i wstawiany wikszy ni aktualny
         previous = current;
         current = current.next;       // przechodzimy do nastpnego elementu
         }
      if(previous==null)               // na pocztku listy...
         first = k;                    // ...first --> k
      else                             // nie na pocztku...
         previous.next = k;            // ...poprzednik --> k
      k.next = current;                // k --> aktualny
      }  // koniec insert()
// -------------------------------------------------------------
   public Link remove()           // zwraca i usuwa pierwszy element listy
      {                           // (zakadamy, e lista jest niepusta)
      Link temp = first;               // zapamitujemy pierwszy element
      first = first.next;              // usuwamy go z listy
      return temp;                     // zwracamy go
      }
// -------------------------------------------------------------
   }  // koniec klasy SortedList
////////////////////////////////////////////////////////////////
class ListInsertionSortApp
   {
   public static void main(String[] args)
      {
      int size = 10;
                                 // tworzymy tablic referencji do elementw
      Link[] linkArray = new Link[size];

      for(int j=0; j<size; j++)  // wypeniamy j elementami
         {                            // losowa warto
         int n = (int)(java.lang.Math.random()*99);
         Link newLink = new Link(n);  // tworzymy nowy element...
         linkArray[j] = newLink;      // ...i wstawiamy go do listy
         }
                                 // wypisujemy elementy tablicy
      System.out.print("Tablica nieposortowana: ");
      for(int j=0; j<size; j++)
         System.out.print( linkArray[j].dData + " " );
      System.out.println("");

                                 // tworzymy list
      SortedList theSortedList = new SortedList(linkArray);

      for(int j=0; j<size; j++)  // kopiujemy elementy z listy do tablicy
         linkArray[j] = theSortedList.remove();

                                 // wypisujemy elementy tablicy
      System.out.print("Tablica posortowana:    ");
      for(int j=0; j<size; j++)
         System.out.print(linkArray[j].dData + " ");
      System.out.println("");
      }  // koniec main()
   }  // koniec klasy ListInsertionSortApp
////////////////////////////////////////////////////////////////
